/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.tags;

import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import java.beans.PropertyEditorSupport;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DatePropertyEditor
extends PropertyEditorSupport {
    private Date date;

    public Object getValue() {
        return this.date;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        SimpleDateFormat dateFormat;
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            dateFormat.setTimeZone(userContext.getTimeZone());
        }
        catch (NullContextException e) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        }
        text = text.trim();
        ParsePosition p = new ParsePosition(0);
        this.date = dateFormat.parse(text, p);
        if (this.date == null) {
            throw new IllegalArgumentException("String \"" + text + "\" doesn't parse as date at index " + p.getErrorIndex());
        }
        if (p.getIndex() < text.length()) {
            SimpleDateFormat timeFormat;
            try {
                ClientUserContext userContext = ClientUserContext.getUserContext();
                timeFormat = new SimpleDateFormat("HH:mm:ss", userContext.getLocale());
                timeFormat.setTimeZone(userContext.getTimeZone());
            }
            catch (NullContextException e) {
                timeFormat = new SimpleDateFormat("HH:mm:ss");
            }
            timeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date time = timeFormat.parse(text, p);
            if (time == null) {
                throw new IllegalArgumentException("String \"" + text + "\" doesn't parse as time at index " + p.getErrorIndex());
            }
            if (p.getIndex() < text.length()) {
                throw new IllegalArgumentException("Date/time string \"" + text + "\" has extra chars at the end: \"" + text.substring(p.getIndex()) + "\".");
            }
            this.date = new Date(this.date.getTime() + time.getTime());
        }
    }
}

